(* $Id: help.ml,v 1.2 2001/04/11 00:13:16 mjambon Exp $ *)

open Tk

open Tk_dino_init

let fr =
"DINO ET DODO

  Dino est le forum de discussion des lves de l'ENS Lyon.
  Un client dino est un logiciel qui permet de lire et de poster des
  messages dans dino. Ce logiciel contacte un serveur, c'est--dire un
  programme qui tourne normalement en permanence sur une machine
  distante. L'accs au rseau est donc ncessaire au moins pour rcuprer
  les nouveaux messages de dino.

  Dodo est un client dino parmi d'autres : celui nomm dino
  fonctionne en mode texte, celui nomm dinel est utilisable 
  l'intrieur de l'diteur de texte emacs.

  Une page web sur les us et coutumes de dino se situe  l'adresse
  suivante : http://www.ens-lyon.fr/~bwack/dino


PREMIRE UTILISATION

  Si tous les cadres semblent vide (message numro 0), cela signifie
  que vous n'tes pas connect. Sinon, tout est pour le mieux et
  passer au chapitre  Utilisation de Dodo .

  Vous devez vous crer un compte dino pour obtenir un nom
  d'utilisateur et un mot de passe (dino-login et
  dino-pass). Normalement, cette opration est effectue
  automatiquement lors de votre inscription  SoftElves. Si vous
  n'avez pas effectu cette opration, tapez la commande suivante dans un
  terminal, puis rpondez aux questions poses :
  /soft/eleves/install-softeleves

  Pour utiliser la nouvelle configuration, vous avez 3 solutions :
    - Dans le menu  Options , cliquez sur  Utilisateur dino , et
      remplissez les 2 champs. Cliquez alors dans le menu  Dino  sur
       Se connecter .
    - Quittez Dodo, ouvrez un nouveau terminal, et tapez  dodo  dans
      ce terminal.
    - Dloguez-vous, a devrait marcher la prochaine fois que vous
      vous loguerez.

  C'est parti !

  Bon, vous ne souhaitez-peut-tre pas lire tous les messages depuis
  la cration dino... Alors cliquez sur le premier thme de la liste des
  thmes (en bas  droite de la fentre principale), et appuyez sur la
  touche 'z' de faon  faire disparatre les 'N' indiquant qu'il y a
  des messages non lus dans les thmes en question.


UTILISATION DE DODO

  Le bouton droit de la souris permet dans plusieurs cas de faire
  apparatre un menu droulant proposant un certain nombre d'actions 
  effectuer, et leurs ventuels raccourcis-clavier.


  Lecture de messages

    Voici une reprsentation schmatique de la fentre principale :

      +---------------------------------+
      |-------------------------+-------|
      |                         |       |
      |         En-tte         |       |
      |                         | Pile* |
      |-------------------------+       |
      |                         |-------|
      |                         |       |
      |         Corps du        |       |
      |         message*        |Thmes*|
      |                         |       |
      |                         |       |
      |---------------------------------|
      +---------------------------------+

    Les 3 zones marques par une toile ont chacune une liste de
    commandes qui leur sont propres. A chacune de ces fonctions est
    associ un raccourci-clavier. La touche tabulation permet de
    naviguer entre ces 3.

    La pile se nomme ainsi pour des raisons historiques. C'est en fait
    une liste de messages conservs d'une session  l'autre en
    souvenir ou pour y rpondre plus tard.

    Pour manipuler des lments de la pile ou de la liste des thmes, en
    slectionner un  l'aide de la souris, puis utiliser le bouton de
    droite pour visualiser les commandes disponibles. Les flches vers
    le haut et vers le bas permettent de se dplacer  l'intrieur de
    la liste.


  dition de nouveaux messages

    Les fonctions  Nouveau  et  Rpondre  crent une fentre
    d'dition. Il n'y a qu' remplir les champs et cliquer sur les
    boutons, dont la fonction ne saurait vous chapper.

    Quelques remarques complmentaires :

      1) Un message peut tre sign ou non. Si c'est le cas, votre nom
         d'utilisateur dino  permanent (dino-login),  ne pas
         confondre avec le pseudonyme, qui lui peut tre chang  souhait.
         Attention ! Dans certains thmes, les messages sont
         automatiquement signs, vous perdez donc votre anonymat mme
         si la case  Signer ...  n'est pas coche.

      2) Le champ  Thmes  permet de dfinir la liste des thmes dans
         lequel le message sera post. Si plusieurs thmes sont
         indiqus, on appelle a un  crosspost ; dans ce cas, les
         noms de thmes doivent tre spars par des espaces.
         Pour faciliter le remplissage de ce champ et viter les
         erreurs de frappe, la touche  entre  permet de complter
         et de corriger les noms de thmes en cours de frappe. La
         touche  tabulation  permet de complter tous les noms de
         thmes de la ligne (dans la mesure du possible) et passe au
         champ suivant.

      3) Le bouton  Plus tard...  permet de ranger le message en
         cours d'dition afin de reprendre sa rdaction plus tard ou
         mme lors d'une session ultrieure. Dans ce cas, un menu
         droulant intitul  Reprendre  apparat dans la fentre
         principale de Dodo.


  Abonnement et dsabonnement

    Vous pouvez ne lire que les thmes qui vous intressent : pour
    cela, cliquez sur le thme qui vous intresse avec le bouton de
    gauche de la souris (ou dplacez-vous avec les flches de votre
    clavier) et pressez la touche 'd'.

    Pour visualiser la liste intgrale des thmes, cochez la case 
     Tous  situe au-dessus de la liste de thmes. Les touches 'a'
    et 'd' permettent respectivement de s'abonner ou de se dsabonner
     un thme slectionn. Les thmes auxquels vous n'tes pas abonn
    apparaissent alors entre crochets.


  Censure

    Vous avez la possibilit de censurer certains messages. Nanmoins,
    la marque de censure n'est qu'une indication pour les logiciels
    clients, le corps du message tant gnralement tout de mme
    transmis par le serveur dino.
    Vous pouvez censurer un message dans les 3 situations suivantes :

      - vous en tes l'auteur et le message est sign
      - vous tes le modrateur du thme
      - vous tes Dieu
    
    Pour censurer ou librer un message, voir le menu droulant
    apparaissant en cliquant sur le bouton de droite de la souris dans
    la zone du message.


  Anonymat

    Certains thmes sont dits signs et d'autres sont dits
    anonymes. Dans les premiers, votre identificateur dino permanent
    (dino-login) apparatra ncessairement. Dans les seconds, vous
    pouvez choisir de signer votre message; il suffit alors de cocher
    la case ad hoc lors de l'dition du message. Dans ce cas, ceci
    authentifie l'origine du message et permet de s'auto-censurer
    lorsque l'on se rend compte que l'on a crit une nerie.

    Si vous tenez  l'anonymat absolu, il vaut mieux vous connecter en
    mode anonyme en utilisant soit l'option -anonymous en ligne de
    commande, soit cocher l'option correspondante dans le menu
    options->divers et se reconnecter.
    En effet, la commande who permet d'afficher la liste des
    utilisateurs connects. Pour vrifier que vous tes invisible,
    utilisez cette commande : pour les commandes, voir le paragraphe
    suivant.


  Commandes de bas niveau

    Vous pouvez,  vos risques et prils, dialoguer plus ou moins
    directement avec le serveur dino en ouvrant une fentre de
    commandes. Entrez votre commande dans la fentre suprieure, et la
    rponse s'affichera dans la partie infrieure.
    La seule commande  connatre est  aide .


  Utilisation hors connexion

    Si vous souhaitez conomiser du temps de connexion, utilisez
    le mode conomique de dodo en passant l'option -eco en ligne de
    commande ou en choisissant l'option adquate dans le menu
    options->divers. Procdez en 2 tapes : activez votre connexion
    internet, connectez-vous au serveur dino (menu dino)
    et tlchargez les nouveaux messages (menu dino) puis
    dconnectez-vous (menu dino). Vous pouvez alors couper votre
    connexion internet et lire tranquillement les messages comme en
    temps normal. Si un message que vous souhaitez lire n'a pas t
    tlcharg, un message vous l'indiquera.



SUGGESTIONS, PARTICIPATION AU PROJET, BUGS

  Si vous voulez qu'un bug soit corrig, le plus efficace est de me
  signaler au mieux dans quelles conditions il est survenu.

  Si vous avez une suggestion  soumettre, n'hsitez pas.

  Si Caml t'intresse, tu peux contribuer au dveloppement de ce
  logiciel, mme de faon trs modeste.

  Mon adresse est la suivante : mjambon@ens-lyon.fr
"


let show_fr () =
  let win = Toplevel.create top in
  Wm.title_set win "Aide de Dodo";
  let frame = Frame.create win in

  let bar = Frame.create frame in
  let button_close = Button.create bar ~text:"Fermer" in

  let text_frame = Frame.create frame in
  let tw = Text.create text_frame ~width:80 ~state:`Normal 
	   ~background:Tk_default.textbg ~foreground:Tk_default.textfg
	   ~font:Tk_default.msg_font ~wrap:`Word in
  
  let sb = Scrollbar.create text_frame in
  Text.configure tw ~yscrollcommand:(Scrollbar.set sb);
  Scrollbar.configure sb ~command:(Text.yview tw);

  let destroy () = destroy win in

  Text.insert tw ~index:beginning ~text:fr;
  Text.configure tw ~state:`Disabled;

  Button.configure button_close ~command:destroy ~takefocus:false;

  pack [button_close];

  pack [tw] ~side:`Left ~expand:true ~fill:`Both;
  pack [sb] ~side:`Right ~expand:false ~fill:`Y;

  pack [text_frame] ~side:`Top ~expand:true ~fill:`Both;
  pack [bar] ~side:`Top ~expand:false ~fill:`X;
  pack [frame] ~expand:true ~fill:`Both
