(* $Id: history.ml,v 1.2 2001/03/19 13:23:03 mjambon Exp $ *)

type 'a cell = { mutable head : 'a cell option;
		 mutable tail : 'a cell option;
		 contents : 'a }

type 'a t = 'a cell ref

let create_internal init = { head = None;
			     tail = None;
			     contents = init }

let create init = ref (create_internal init)
			     
exception Beginning
exception End

let forward x =
  match !x with
      { head = None } -> raise End
    | { head = Some t } -> x := t; t.contents

let back x =
  match !x with
      { tail = None } -> raise Beginning
    | { tail = Some t } -> x := t; t.contents

let push x elem =
  let t = create_internal elem in
  t.tail <- Some !x;
  (!x).head <- Some t;
  x := t

let current x = !x.contents
