(* $Id: kill.ml,v 1.4 2001/06/16 17:04:58 mjambon Exp $ *)

open Connect
open Com
open Theme
open Dino_message_type
open Header

let kill msg =
  let hdr = msg.msg_header in
  let num = hdr.hr_num
  and th_list = hdr.hr_themes in

  let kill_th th =
    let action = function
	Finite_response (1,["message censure"]) -> 
	  Tk_info.display "Message censur"
      | Finite_response (1,[s]) -> Tk_info.display s
      | Error s -> Tk_info.display s
      | other -> bad_response_light other in
    
    dino_send_command ["censure ";string_of_int num;" ";th;"\n"] [action] in

  List.iter ~f:kill_th th_list

let unkill msg =
  let hdr = msg.msg_header in
  let num = hdr.hr_num
  and th_list = hdr.hr_themes in

  let unkill_th th =
    let action = function
	Finite_response (1,["message libere"]) -> 
	  Tk_info.display "Message libr"
      | Finite_response (1,[s]) -> Tk_info.display s
      | Error s -> Tk_info.display s
      | other -> bad_response_light other in
    
    dino_send_command ["libere ";string_of_int num;" ";th;"\n"] [action] in
  
  List.iter ~f:unkill_th th_list
