(* $Id: login.ml,v 1.8 2001/06/17 01:11:54 mjambon Exp $ *)

open Printf
open Unix
open ThreadUnix
open Tk

open Dodo
open Dodo_settings
open Dodo_window
open Tk_dino_init


let server_window_internal t =	
  let left_frame = Frame.create t in
  let lb = Listbox.create left_frame in
  let sb = Scrollbar.create left_frame in
  Listbox.configure lb ~yscrollcommand:(Scrollbar.set sb);
  Scrollbar.configure sb ~command:(Listbox.yview lb);
  
  
  let right_frame = Frame.create t in
  
  let buttons_frame = Frame.create right_frame in

  let upper_frame = Frame.create right_frame in
  let label_frame = Frame.create upper_frame in
  let entry_frame = Frame.create upper_frame in
  
  let server_label = Label.create label_frame ~text:"Serveur"
  and server_entry = Entry.create entry_frame in
  let port_label = Label.create label_frame ~text:"Port"
  and port_entry = Entry.create entry_frame in
  
  let add_button = Button.create buttons_frame ~text:"Ajouter"
  and rm_button = Button.create buttons_frame ~text:"Supprimer"
  and edit_button = Button.create buttons_frame ~text:"Modifier"
  and set_button = Button.create buttons_frame ~text:"Prfrer ce serveur"
  and close_button = Button.create buttons_frame 
		     ~text:"Fermer" ~command:(fun () -> destroy t) in
  
  Wm.title_set t "Serveurs dino";
  
  let table = ref [||] in
  let display () =
    let list = !dino_servers in
    table := Array.of_list list;
    let texts = List.map ~f:(fun (s,p) -> sprintf "%s:%i" s p) list in
    Listbox.delete lb ~first:(`Num 0) ~last:`End;
    Listbox.insert lb ~index:`End ~texts in
  
  let add () =
    try 
      let server = Entry.get server_entry
      and port = (int_of_string (Entry.get port_entry)) in
      add_server (server,port);
      display ()
    with _ -> () in
  
  let remove () =
    try
      let num = lb_num (Listbox.curselection lb) in
      let l = ref [] in
      let t = !table in
      let len = Array.length t in
      if len > 1 then
	(for i = len - 1 downto 0 do
	   if i <> num then
	     l := t.(i) :: !l
	 done;
	 dino_servers := !l;
	 display ())
    with No_selection -> () in
  
  let put_first () =
    try
      let num = lb_num (Listbox.curselection lb) in
      let l = ref [] in
      let t = !table in
      let len = Array.length t in
      if len > 0 then
	let x = t.(num) in
	for i = len - 1 downto 0 do
	  if i <> num then
	    l := t.(i) :: !l
	done;
	dino_servers := x::!l;
	for i = num-1 downto 0 do
	  t.(i+1) <- t.(i)
	done;
	t.(0) <- x;
	display ()
    with No_selection -> () in
  
  let change () =
    try
      let server = Entry.get server_entry
      and port = (int_of_string (Entry.get port_entry)) in
      
      let num = lb_num (Listbox.curselection lb) in
      let t = !table in
      t.(num) <- (server,port);
      dino_servers := Array.to_list t;
      display ()
    with _ -> () in
  
  Button.configure edit_button ~command:change;
  Button.configure add_button ~command:add;
  Button.configure rm_button ~command:remove;
  Button.configure set_button ~command:put_first;
  
  let fill _ =
    try
      let t = !table in
      let num = lb_num (Listbox.curselection lb) in
      let (server,port) = t.(num) in
      Entry.delete_range server_entry ~start:(`Num 0) ~stop:`End;
      Entry.insert server_entry ~index:(`Num 0) ~text:server;
      Entry.delete_range port_entry ~start:(`Num 0) ~stop:`End;
      Entry.insert port_entry ~index:(`Num 0) ~text:(string_of_int port);
    with _ -> () in
  
  bind lb ~events:[`ButtonReleaseDetail 1] ~action:fill;
  
  pack [lb] ~side:`Left ~expand:true ~fill:`Both;
  pack [sb] ~side:`Right ~expand:false ~fill:`Y;
  
  pack [edit_button;add_button;rm_button;set_button;close_button] 
  ~side:`Top ~expand:true ~fill:`Both ~anchor:`N;
  pack [server_label;port_label] 
  ~side:`Top ~expand:true ~fill:`None ~anchor:`Ne;
  pack [server_entry] 
  ~side:`Top ~expand:true ~fill:`X ~anchor:`N;
  pack [port_entry] 
  ~side:`Top ~expand:true ~fill:`X ~anchor:`N;
  pack [label_frame] ~side:`Left ~expand:false ~fill:`X;
  pack [entry_frame] ~side:`Left ~expand:true ~fill:`X;
  pack [upper_frame] ~side:`Top ~expand:false ~fill:`Both ~anchor:`N;
  pack [buttons_frame] ~side:`Top ~expand:true ~fill:`Both ~anchor:`N;
  pack [left_frame; right_frame] ~side:`Left ~expand:true ~fill:`Both;
  
  display ()

let login_window_internal t =
  let upper_frame = Frame.create t
  and buttons_frame = Frame.create t in

  let left_frame = Frame.create upper_frame
  and right_frame = Frame.create upper_frame in
  let login_label = Label.create left_frame ~text:"Login dino"
  and pass_label = Label.create left_frame ~text:"Mot de passe" in
  let login_entry = Entry.create right_frame
  and pass_entry = Entry.create right_frame in

  Entry.insert login_entry ~index:(`Num 0) ~text:!dino_login;
  Entry.insert pass_entry ~index:(`Num 0) ~text:!dino_pass;

  let close () = destroy t in

  let ok () =
    let login = Entry.get login_entry
    and pass = Entry.get pass_entry in
    dino_login := login;
    dino_pass := pass;
    close () in

  let ok_button = Button.create buttons_frame 
		  ~text:"OK" ~command:ok in
  let cancel_button = Button.create buttons_frame 
		      ~text:"Annuler" ~command:close in
  
  Wm.resizable_set t ~width:false ~height:false;
  Wm.title_set t "Dfinition de l'utilisateur dino";

  pack [ok_button;cancel_button] 
  ~side:`Left ~expand:true ~fill:`Both;
  pack [login_label;pass_label] 
  ~side:`Top ~expand:false ~anchor:`Ne;
  pack [login_entry;pass_entry] 
  ~side:`Top ~expand:true ~fill:`X ~anchor:`N;

  pack [left_frame;right_frame] ~side:`Left ~expand:true ~fill:`X;
  pack [upper_frame;buttons_frame] ~side:`Top ~expand:true ~fill:`Both


let server_window = unique_window server_window_internal
let login_window = unique_window login_window_internal


let rec get () =
  match (!dino_login, !dino_pass) with
      "",_ -> login_window (); raise Reconnect_later
    | _,"" -> login_window (); raise Reconnect_later
    | cpl -> cpl
