(* Dino client in Objective Caml *)
(* $Id: main.ml,v 1.25 2001/07/06 11:34:34 mjambon Exp $ *)

open Printf
open Unix
open ThreadUnix
open Pervasives

open Dodo
open Dodo_settings
open Com
open Connect
open Login
open Theme

let version = "1.12"


let dodo_clean () =
  User_info.clean ();
  Theme_info.clean ()

open Arg

let errmsg = "Options :"

let rec keywords = [
  "-aide",
  Unit (fun () -> usage ~keywords ~errmsg; exit 0),
  "       affiche cette liste d'options";

  "-anonymous",
  Set anonymous,
  "  devenir anonyme pour la commande who";

  "-clean",
  Unit (fun () -> dodo_clean (); exit 0),
  "      suppression des informations qui sont stockes localement
               et qui seront rgnres automatiquement  la session suivante";

  "-eco",
  Set eco,
  "        mode conomique : connexion non automatique";

  "-help",
  Unit (fun () -> usage ~keywords ~errmsg; exit 0),
  "       affiche cette liste d'options";

  "-version",
  Unit (fun () -> print_endline version; flush stdout; exit 0),
  "    affiche le numro de version du logiciel";

]

(* Startup function *)
let dino_start () = 
  User_info.input ();
  Theme_info.input ();
  Dino_stack.load ();

  Connect.at_first_connection := Some Dino_stack.refresh;
  if not !eco then
    (try timed_connect ()
     with Reconnect_later -> Tk_info.display "Impossible de se connecter");
  let user_theme_list = Dinorc.read () in
  (match user_theme_list with
       hd::tl ->
	 let th_last_read =
	   List.fold_left 
	   ~f:(fun maxi th -> 
		 if th.theme_last_read > maxi.theme_last_read then th
		 else maxi)
	   ~init:hd tl in
	 Display_dino_message.current_num := th_last_read.theme_last_read;
	 Theme.set th_last_read
	 
     | [] -> ());

  Theme.commit user_theme_list;
  Theme.print ();
  if Connect.off () then Dino_stack.refresh ()


let _ =
  Sys.catch_break true;
  
  parse ~keywords ~others:(fun s -> usage ~keywords ~errmsg) ~errmsg;
  
  try 
    (dino_start ();
     
     if Connect.on () then
       Dino_message.check_new_all ();
     let th_list = Theme.get_all () in
     Display_dino_message.num (Theme.last th_list);
     Theme.print ();
     Tk.mainLoop ();
  
     (*  if Connect.succeeded () then*)
     if !Theme.full_list <> [] then
       Dinorc.save ();
     Dino_stack.save ();
     Dodo_option.save ();
     Being_edited.output ();
     Theme_info.output ();
     User_info.output ())

  with Sys.Break -> ()
    | exn -> raise exn
