(* $Id: new_msg.ml,v 1.4 2001/04/21 00:19:04 mjambon Exp $ *)

open Header

let prn s = print_string s; print_newline ()

type t = { edit_subject : Textvariable.textVariable;
	   edit_themes : Textvariable.textVariable;
	   edit_author : Textvariable.textVariable;
	   edit_rep : Textvariable.textVariable;
	   edit_sign : Textvariable.textVariable;
	   edit_html : Textvariable.textVariable }


let create () =
  { edit_subject = Textvariable.create ();
    edit_themes = Textvariable.create ();
    edit_author = Textvariable.create ();
    edit_rep = Textvariable.create ();
    edit_sign = Textvariable.create ();
    edit_html = Textvariable.create () }


let string_of_intlist l =
  String.concat ~sep:" " (List.map ~f:string_of_int l)

let load_header h e =
  Textvariable.set e.edit_subject h.hr_subject;
  Textvariable.set e.edit_themes (String.concat ~sep:" " h.hr_themes);
  Textvariable.set e.edit_author h.hr_author;
  Textvariable.set e.edit_rep (string_of_intlist h.hr_rep);
  Textvariable.set e.edit_sign (if !Dodo_settings.dino_sign then "y" else "")

let output_header e h =
  h.hr_subject <- (Textvariable.get e.edit_subject);
  h.hr_themes <- Stringlist.of_string (Textvariable.get e.edit_themes);
  h.hr_author <- (Textvariable.get e.edit_author);
  h.hr_rep <- Intlist.of_string (Textvariable.get e.edit_rep);
  h.hr_sign <- Textvariable.get e.edit_sign = "y";
  h.hr_html <- Textvariable.get e.edit_html = "y"
