(* $Id: post.ml,v 1.8 2001/06/16 17:05:00 mjambon Exp $ *)

open Com
open Connect

(*
Utilisation de la fonction poste
|poste them t1 [them t2] ... [signe] [pseudo x] ... [rep y1] [rep y2] [sujet s]
|poste un message dans les thmes t1, t2...; ventuellement le signe;
|utilise ventuellement le pseudo x; rpond aux messages y1, y2 ...
|et adopte le sujet s (s peut contenir des espaces non  multiples)
|Attention: dans certains thmes les messages sont toujours signs
*)

let re_msg = Str.regexp "Message \\([0-9]+\\) poste"

let message ~themes ?(html=false) ?(replies=[]) ?(sign=false) 
  ?nick ?subject text =
  (* The list of strings to send, in reverse order: *)
  let cmd = if html then "poste2" else "poste" in

  let list = ref [cmd] in
  List.iter ~f:(fun them -> 
		  list := them::" them ":: !list) themes;
  List.iter ~f:(fun rep -> 
		  list := (string_of_int rep)::" rep ":: !list) replies;

  if sign then
    list := " signe":: !list;

  (match nick with
       None -> ()
     | Some s -> list := s::" pseudo ":: !list);

  (match subject with
      None -> ()
    | Some subj -> list := subj::" sujet ":: !list);

  list := "\n":: !list;

  let action1 = function
      Finite_response (1,[s]) -> ()
    | Error s -> Tk_info.display s
    | other -> bad_response_light other in
  (* entrez le message, termine par une ligne ne contenant qu'un point *)

  list := text :: !list;
  if text.[String.length text-1] <> '\n' then
    list := "\n"::!list;

  list := ".\n"::!list;

  let action2 = function (* Message 95227 poste *) 
      Finite_response (1,[s]) -> 
	if Str.string_match ~pat:re_msg s ~pos:0 then
	  let num = Str.matched_group 1 s in
	  Tk_info.display (Printf.sprintf "Message %s envoy !" num)
	else Tk_info.display s
    | Error s -> Tk_info.display s
    | other -> bad_response_light other in

  Connect.dino_send_command (List.rev !list) [action1;action2]

