(* $Id: tab_completion.ml,v 1.4 2001/03/21 02:26:55 mjambon Exp $ *)

open Tk
open Printf

open Theme

let prn s = print_string s; print_newline ()

let current = (`Mark "insert", [])
let previous = (`Mark "insert", [`Char (-1)])
let word_start = (`Mark "insert", [`Char (-1);`Wordstart])
let word_end = (`Mark "insert", [`Wordend])

let complete_tw tw dic =
  let key = Text.get tw ~start:word_start ~stop:current in
  match Dictionary.verbose_complete dic key with
      `Partial (s,_) -> 
	Text.insert tw ~index:current ~text:s
    | `Completed (s,_) -> 
	Text.insert tw ~index:current ~text:s
    | `Exact _ -> ()
    | `Shorter s -> ()


let bind_text_with_themes tw = 
  bind tw 
  ~breakable:true
  ~extend:false
  ~events:[`KeyPressDetail "Tab"]
  ~action:(fun _ -> 
	     complete_tw tw Theme.completion_table)


let rec backwards_local s = function
    -1 -> 0
  | i -> if s.[i] = ' ' then (i+1) else backwards_local s (i-1)

let backword s i =
  let start = (backwards_local s (i-1)) in
  let len = String.length s in
  String.sub s ~pos:0 ~len:start,
  String.sub s ~pos:start ~len:(i-start),
  (if len > i then String.sub s ~pos:i ~len:(len-i) else "")

let (@@) f g = fun x -> f (g x)

let concat_themes ?prefix l =
  let slist = List.map ~f:(fun th -> th.theme_name) l in
  let l' = match prefix with None -> slist | Some s -> s::slist in
  String.concat ~sep:" " l'


let rec get ~info dic s =
  match Dictionary.complete dic s with
      `Partial (s',l) -> info (concat_themes ~prefix:"Propositions :" l); s^s'
    | `Completed (s',_) -> info ""; s^s'^" "
    | `Exact _ -> info ""; s^" "
    | `Shorter s' -> get ~info dic s'

let rec get_bool dic s =
  match Dictionary.complete dic s with
      `Partial (s',l) -> (s^s', false)
    | `Completed (s',_) -> (s^s'^" ", false)
    | `Exact _ -> (s^" ", true)
    | `Shorter s' -> (fst (get_bool dic s'), false)

let complete_entry ~info ew dic =
  let s = Entry.get ew in
  let i = Entry.index ew ~index:`Insert in
  let (s1,s2,s3) = backword s i in
  let subst = get ~info dic s2 in
  Entry.delete_range ew ~start:(`At 0) ~stop:`End;
  Entry.insert ew ~index:`End ~text:s1;
  Entry.insert ew ~index:`End ~text:subst;
  Entry.insert ew ~index:`End ~text:s3


let complete_entry_full ew dic =
  let l = Stringlist.of_string (Entry.get ew) in
  let l' = List.map ~f:(get ~info:(fun _->()) dic) l in
  let text = String.concat ~sep:" " l' in
  Entry.delete_range ew ~start:(`At 0) ~stop:`End;
  Entry.insert ew ~index:`End ~text

let complete_entry_full_check ew dic =
  let unchanged = ref true in
  let l = Stringlist.of_string (Entry.get ew) in
  let l' = List.map ~f:(fun s -> 
			  match get_bool dic s with
			      (s',true) -> s'
			    | (s',false) -> unchanged:= false; s') l in
  let text = String.concat ~sep:" " l' in
  Entry.delete_range ew ~start:(`At 0) ~stop:`End;
  Entry.insert ew ~index:`End ~text;
  !unchanged && l' <> []



let bind_entry_with_themes ~info ew = 
  bind ew
  ~events:[`KeyPressDetail "Return"]
  ~action:(fun _ -> complete_entry ~info ew Theme.completion_table);
  bind ew
  ~events:[`KeyPressDetail "Tab"]
  ~action:(fun _ -> complete_entry_full ew Theme.completion_table)
