(* $Id: tk_dino_config.ml,v 1.26 2001/06/17 01:11:57 mjambon Exp $ *)

open Tk
open Tk_dino_init
open Header
open Theme
open Reply
open Dino_message

(*let (add_frame, iter_frame) = 
  let accu = ref [] in
  ((fun fr -> accu := fr::!accu),
   (fun f -> List.iter ~f !accu))*)

class ['a] set = object (_:'a)
  val mutable list = []
  method add x = list <- x::list
  method add_list l = list <- List.rev_append l list
  method iter f = List.iter ~f list
end

let labels = new set
let frames = new set
let messages = new set
let buttons = new set
let menubuttons = new set
let radiobuttons = new set
let listboxes = new set
let scrollbars = new set
let menus = new set

(* Closing function *)
let close = closeTk

(* Main window *)
let _ = 
  Toplevel.configure top ~width:750;
  Focus.follows_mouse ()

(* Background menu *)
let show_menu _ =
  let (x,y) =  Winfo.pointerxy text in
  Menu.popup ~x ~y text_menu

let _ =
  let events = [`ButtonPressDetail 3] in
  List.iter ~f:(bind ~events ~action:show_menu) msg_labels;
  List.iter ~f:(bind ~events ~action:show_menu) msg_fields;
  bind ~events ~action:show_menu message_frame;
  bind ~events ~action:show_menu header;
  bind ~events ~action:show_menu f1;
  bind ~events ~action:show_menu f2;
  bind ~events ~action:show_menu text


(* Menu bar *)
let _ =
  Menu.add_command menu_dino
  ~label:"Se connecter" ~command:Connect.timed_connect;
  Menu.add_command menu_dino
  ~label:"Se dconnecter" ~command:Connect.disconnect;
  Menu.add_command menu_dino
  ~label:"Tout tlcharger" ~command:Dino_message.preload;
  Menu.add_command menu_dino
  ~label:"Fentre de commandes" ~command:Dino_commands.init;
(*  Menu.add_command menu_dino
  ~label:"Enregistrer" ~command:(fun () -> ());
  Menu.add_command menu_dino
  ~label:"Imprimer" ~command:(fun () -> ());*)
  Menu.add_command menu_dino
  ~label:"Quitter" ~command:closeTk;
  Menubutton.configure mb_dino ~menu:menu_dino; 

  (* Navigation menu, made later, with the background menu *)
  Menubutton.configure mb_navigation ~menu:menu_navigation; 

  Menu.add_command menu_options
  ~label:"Utilisateur dino" ~command:Login.login_window;
  Menu.add_command menu_options
  ~label:"Serveurs" ~command:Login.server_window;
  Menu.add_command menu_options
  ~label:"diteur" ~command:Editor.config_window;
  Menu.add_command menu_options
  ~label:"Divers" ~command:Dodo_settings_window.show;
(*
  Menu.add_command menu_options
  ~label:"Apparence" ~command:(fun () -> ());
*)
  Menubutton.configure mb_options ~menu:menu_options;

  Menubutton.configure mb_replies ~menu:menu_replies;

  Menu.add_command menu_help
  ~label:"Dodo" ~command:Help.show_fr;
(*
  Menu.add_command menu_help
  ~label:"Rseau" ~command:(fun () -> ());
*)
  Menubutton.configure mb_help ~menu:menu_help;

  let l = [mb_dino; mb_navigation; mb_options; mb_replies] in
  pack l ~side:`Left;
  pack [mb_help] ~side:`Right;
  menubuttons#add_list l;
  menubuttons#add mb_help;

  Being_edited.input ();
  if !Being_edited.list = [] then
    Pack.forget [mb_replies]
  else
    Reply.update ()


(* Navigation bar *)
let _ =
  Button.configure ~command:Display_dino_message.previous_th  
  ~takefocus:false button_prev_th;
  Button.configure ~command:Display_dino_message.next_th   
  ~takefocus:false button_next_th;
  Button.configure ~command:Display_dino_message.back  
  ~takefocus:false button_back;
  Button.configure ~command:Display_dino_message.forward   
  ~takefocus:false button_forward;
  Button.configure ~command:Display_dino_message.previous   
  ~takefocus:false button_prev;
  Button.configure ~command:Display_dino_message.next   
  ~takefocus:false button_next;
  Button.configure ~command:Display_dino_message.next_unread   
  ~takefocus:false button_unread;
  Button.configure ~command:Reply.current   
  ~takefocus:false button_reply;
  Button.configure ~command:Reply.new_msg   
  ~takefocus:false button_new;
(*
  bind button_unread ~events:[`KeyPressDetail "Return"]
  ~action:(fun _ -> Display_dino_message.next_unread ());
*)

  bind msg_entry ~events:[`KeyPressDetail "Return"]
  ~action:(fun _ -> Display_dino_message.from_entry ());
  bind msg_entry_label ~events:[`Enter]
  ~action:(fun _ -> Focus.set msg_entry);

  let blist = [button_prev_th;button_next_th;
	       button_back; button_forward;
	       button_prev;button_next;
	       button_unread;button_reply;button_new] in
  pack blist ~side:`Left;
  buttons#add_list blist;

  pack [coe msg_entry; coe msg_entry_label] ~side:`Right;
  labels#add msg_entry_label

(* Header *)
let _ =
  pack msg_labels ~side:`Top ~anchor:`W;
  pack msg_fields ~side:`Top ~anchor:`W;
  pack [rep_frame] ~side:`Top ~anchor:`W;
  labels#add_list msg_labels;
  labels#add_list msg_fields;
  frames#add rep_frame;

  bind header ~events:[`Enter]
  ~action:(fun _ -> Focus.set text_sb);

  pack [f1] ~side:`Left ~expand:false ~anchor:`Nw ~fill:`None;
  pack [f2] ~side:`Left ~expand:true ~anchor:`Nw ~fill:`X;
  pack [header] ~side:`Top ~expand:false ~fill:`X ~anchor:`Nw;
  frames#add f1;
  frames#add f2;
  frames#add header

(* Text widget and message frame *)
let _ =
  Text.configure text ~takefocus:false;

  Focus.set text_sb;

  bind text ~events:[`Enter]
  ~action:(fun _ -> Focus.set text_sb);

  bind text_sb ~events:[`KeyPressDetail "q"]
  ~action:(fun _ -> close ());
  bind text_sb ~events:[`KeyPressDetail "Return"]
  ~action:(fun _ -> Display_dino_message.next_unread ());
  bind text_sb ~events:[`KeyPressDetail "Left"]
  ~action:(fun _ -> Display_dino_message.previous_th ());
  bind text_sb ~events:[`KeyPressDetail "Right"]
  ~action:(fun _ -> Display_dino_message.next_th ());

  bind text_sb ~events:[`KeyPressDetail "b"]
  ~action:(fun _ -> Display_dino_message.back ());
  bind text_sb ~events:[`KeyPressDetail "f"]
  ~action:(fun _ -> Display_dino_message.forward ());

  bind text_sb ~events:[`KeyPressDetail "r"]
  ~action:(fun _ -> Reply.current ());
  bind text_sb ~events:[`KeyPressDetail "m"]
  ~action:(fun _ -> Reply.new_msg ());
  bind text_sb ~events:[`KeyPressDetail "a"]
  ~action:(fun _ -> Dino_stack.add ());

  bind text_sb ~events:[`KeyPressDetail "k"]
  ~action:(fun _ -> Current_msg.kill ());
  bind text_sb ~events:[`KeyPressDetail "u"]
  ~action:(fun _ -> Current_msg.unkill ());
  bind text_sb ~events:[`KeyPressDetail "K"]
  ~action:(fun _ -> Current_msg.zap ());
  bind text_sb ~events:[`KeyPressDetail "U"]
  ~action:(fun _ -> Current_msg.unzap ());

  bind text_sb ~events:[`KeyPressDetail "colon"]
  ~action:(fun _ -> Dino_commands.init ())



let _ = 
  let sep () =
    Menu.add_separator text_menu;
    Menu.add_separator menu_navigation in
  let add label command =
    Menu.add_command text_menu ~label ~command;
    Menu.add_command menu_navigation ~label ~command in
  let sep_no_popup () =
    Menu.add_separator menu_navigation in
  let add_no_popup label command =
    Menu.add_command menu_navigation ~label ~command in
  let sep_no_navig () =
    Menu.add_separator text_menu in
  let add_no_navig label command =
    Menu.add_command text_menu ~label ~command in

  add
    "Quoi de neuf ? (Entre)"
    Display_dino_message.next_unread;

  sep ();
  add
    "<- : Prcdent dans le thme courant (Flche gauche)" 
    Display_dino_message.previous_th;
  add
    "-> : Suivant dans le thme courant (Flche droite)"
    Display_dino_message.next_th;

  sep ();
  add
    "<= : Prcdent dans l'historique (b)" 
    Display_dino_message.back;
  add
    "=> : Suivant dans l'historique (f)"
    Display_dino_message.forward;
  
  sep ();
  add "Rpondre  ce message (r)" Reply.current;
  add "Crer un nouveau message (m)" Reply.new_msg;
  add "Ajouter ce message  la pile (a)" Dino_stack.add;
  
  sep ();
  add "Censurer le message courant (k)" Current_msg.kill;
  add "Lever la censure sur le message courant (u)" Current_msg.unkill;
  add "Ne pas lire les messages de cette discussion (K)" Current_msg.zap;
  add "Lire quand mme les messages de cette discussion (U)" Current_msg.unzap;
  add_no_popup "Reprendre toutes les discussions" Zap.unzap_all;

  sep_no_popup ();
  add_no_popup "Envoyer des bidou-bidous" Bidou_bidou.send;

  sep_no_navig ();
  add_no_navig "Fentre de commandes (:)" Dino_commands.init;

  sep_no_navig ();
  add_no_navig "Quitter (q)" close;


(*
  bind text ~events:[`KeyPressDetail "Tab";`KeyReleaseDetail "Tab"]
  ~action:(fun _ ->  Focus.set (Focus.next text));
*)
  pack [text] ~side:`Left ~expand:true ~fill:`Both;
  pack [text_sb] ~side:`Left ~expand:false ~fill:`Y


(* Dino stack *)
let _ =
  Scrollbar.configure stack_sb ~takefocus:false;

  Tk.bind stack_lb
  ~events:[`KeyPressDetail "a"] ~action:(fun _ -> Dino_stack.add ());
  Tk.bind stack_lb
  ~events:[`KeyPressDetail "m"] ~action:(fun _ -> Reply.new_msg ());
  bind button_add ~events:[`Enter]
  ~action:(fun _ -> Focus.set stack_lb);
  bind stack_sb ~events:[`Enter]
  ~action:(fun _ -> Focus.set stack_lb);
  
  pack [stack_sb] ~side:`Right ~fill:`Y;
  scrollbars#add stack_sb;
  pack [stack_lb] ~side:`Left ~expand:true ~fill:`Both;
  listboxes#add stack_lb
    

(* Themes *)
let _ =
  Radiobutton.configure themes_b1 ~command:Theme.print_selection   
  ~takefocus:false;
  Radiobutton.configure themes_b2 ~command:Theme.print_all  
  ~takefocus:false;

  Scrollbar.configure themes_sb ~takefocus:false;

  bind themes_lb ~events:[`KeyPressDetail "m"]
  ~action:(fun _ -> Reply.new_msg ());
  bind radio_frame ~events:[`Enter]
  ~action:(fun _ -> Focus.set themes_lb);
  bind themes_sb ~events:[`Enter]
  ~action:(fun _ -> Focus.set themes_lb);

  pack [themes_b1;themes_b2] ~side:`Left ~fill:`None;
  pack [themes_sb] ~side:`Right ~fill:`Y;
  pack [themes_lb] ~side:`Left ~expand:true ~fill:`Both;
  radiobuttons#add themes_b1;
  radiobuttons#add themes_b2;
  scrollbars#add themes_sb;
  listboxes#add themes_lb


(* Right frame *)
let _ =
  Button.configure button_add ~command:Dino_stack.add  
  ~takefocus:false;

  pack [button_add] ~expand:false ~fill:`X;
  pack [dinostack_frame] ~expand:false ~fill:`Both;
  pack [radio_frame] ~expand:false ~fill:`X;
  pack [themes_frame] ~expand:true ~fill:`Both;
  buttons#add button_add;
  frames#add dinostack_frame;
  frames#add radio_frame;
  frames#add themes_frame;
  Dino_stack.display ()

(* Body *)
let _ =
  pack [message_frame]
  ~side:`Left ~expand:true ~fill:`Both ~anchor:`Nw;
  pack [right_frame]
  ~side:`Left ~expand:false ~fill:`Y ~anchor:`Nw;
  frames#add message_frame;
  frames#add right_frame

(* Large frames *)
let _ =
  Wm.title_set top "Dodo";

  pack [menu_bar;navigation_bar] 
  ~side:`Top ~expand:false ~fill:`X ~anchor:`N;
  pack [body] ~side:`Top ~expand:true ~fill:`Both ~anchor:`Nw;
  pack [infobar] 
  ~side:`Bottom ~expand:false ~fill:`None ~anchor:`Sw;
  frames#add menu_bar;
  frames#add navigation_bar;
  frames#add body;
  messages#add infobar;
  

  pack [baseframe] ~expand:true ~fill:`Both;
  frames#add baseframe

let _ =
  menus#add_list [menu_dino;
		  menu_navigation;
		  menu_options;
		  menu_replies;
		  menu_help;
		  text_menu;
		  stack_menu]

(* Colorization *)
let _ =
  if !Dodo_settings.psy then 
    begin
      labels#iter (fun x -> Label.configure x ~background:(Color.bg ()));
      frames#iter (fun x -> Frame.configure x ~background:(Color.bg ()));
      messages#iter 
	(fun x -> Message.configure x ~background:(Color.bg ()));
      buttons#iter (fun x -> Button.configure x ~background:(Color.bg ()));
      menubuttons#iter 
	(fun x -> Menubutton.configure x ~background:(Color.bg ()));
      radiobuttons#iter 
	(fun x -> Radiobutton.configure x ~background:(Color.bg ()));
      listboxes#iter 
	(fun x -> Listbox.configure x ~background:(Color.bg ()));
      scrollbars#iter 
	(fun x -> Scrollbar.configure x ~background:(Color.bg ()));
      menus#iter 
	(fun x -> Menu.configure x ~background:(Color.bg ()));
  end
