(* $Id: tk_dino_init.ml,v 1.17 2001/06/16 20:32:56 mjambon Exp $ *)

open Tk
(*open Tk_dino*)

let beginning = (`Linechar (0,0), [`Char 0])
let text_end = (`End, [`Wordend])

(* Main window *)
let top = Tk.openTk ()

(* Base frame *)
let baseframe = Frame.create top

(* Body *)
let body = Frame.create  baseframe
let message_frame = Frame.create body

(* Right frame *)
let right_frame = Frame.create body


(* Menu bar *)
let menu_bar = 
  Frame.create baseframe ~borderwidth:2 ~relief:`Raised
 

(* Menu and Menubutton *)
let mb_dino = Menubutton.create menu_bar ~text:"Dino" 
	     
let mb_navigation = Menubutton.create menu_bar ~text:"Navigation"
	     
let mb_options = Menubutton.create menu_bar ~text:"Options"
	     
let mb_replies = Menubutton.create menu_bar ~text:"Reprendre"
let mb_help = Menubutton.create menu_bar ~text:"Aide"
	     

let menu_dino = Menu.create mb_dino
	     
let menu_navigation = Menu.create mb_navigation
	     
let menu_options = Menu.create mb_options
	     
let menu_replies = Menu.create mb_replies
	     
let menu_help = Menu.create mb_help
	     


let navigation_bar = Frame.create baseframe
		    
let button_prev_th = Button.create navigation_bar ~text:"<-"
		    
and button_next_th = Button.create navigation_bar ~text:"->"
		    
and button_back = Button.create navigation_bar ~text:"<="
		    
and button_forward = Button.create navigation_bar ~text:"=>"
		    
and button_prev = Button.create navigation_bar ~text:"-1"
		    
and button_next = Button.create navigation_bar ~text:"+1"
		    
and button_unread = Button.create navigation_bar ~text:"Quoi de neuf ?"
		    
and button_reply = Button.create navigation_bar ~text:"Rpondre"
		    
and button_new = Button.create navigation_bar ~text:"Nouveau"
		    


let msg_entry_label = Label.create navigation_bar ~text:"Numro :"
		    
let msg_entry_var = Textvariable.create ()
let msg_entry = Entry.create navigation_bar 
		~textvariable:msg_entry_var
		~width:10


(* Infofar *)
let infobar = Message.create baseframe ~text:"" ~justify:`Left 
	      ~width:Tk_default.width
	     


(* Message header *)
let header = Frame.create message_frame
	    
let f1 = Frame.create header
and f2 = Frame.create header

(* f1: left: labels *)
let subject_string = "Sujet"
and theme_string = "Thme(s)"
and author_string = "Pseudonyme"
and realauthor_string = "Auteur"
and date_string = "Date"
and num_string = "Numro"
and rep_string = "En rponse "

let make_label1 text = Label.create f1 ~text
let msg_labels = [make_label1 subject_string;
		  make_label1 theme_string;
		  make_label1 author_string;
		  make_label1 realauthor_string;
		  make_label1 date_string;
		  make_label1 num_string;
		  make_label1 rep_string]

(* f2: right: mutable fields *)
let make_label2 () = Label.create f2 
		    ~justify:`Left ~anchor:`W
let subject_field = make_label2 ()
and themes_field = make_label2 ()
and author_field = make_label2 ()
and realauthor_field = make_label2 ()
and date_field = make_label2 ()
and num_field = make_label2 ()
and rep_frame = Frame.create f2
let msg_fields = [ subject_field; themes_field;
		   author_field; realauthor_field; date_field;
		   num_field ]


(* Text widget *)
let text = Text.create message_frame ~width:Tk_default.msg_width
	   ~background:!Dodo_settings.textbg 
	   ~foreground:!Dodo_settings.textfg
	   ~cursor:!Dodo_settings.textcursor
	   ~insertbackground:!Dodo_settings.textinsertbg
	   ~font:Tk_default.msg_font

let text_end = (`End, [`Lineend])

let text_sb = Scrollbar.create message_frame

let text_menu = Menu.create message_frame

let _ =
  Text.configure text ~yscrollcommand:(Scrollbar.set text_sb);
  Scrollbar.configure text_sb ~command:(Text.yview text)

(* Dino stack *)
let button_add = Button.create right_frame 
		 ~text:"Ajouter" 
		

let dinostack_frame = Frame.create right_frame
		      (*~width:Tk_default.stack_width
		      ~height:Tk_default.stack_height*)
let stack_lb = Listbox.create dinostack_frame
let stack_sb = Scrollbar.create dinostack_frame
let stack_menu = Menu.create dinostack_frame

let scroll_link sb lb =
  Listbox.configure lb ~yscrollcommand:(Scrollbar.set sb);
  Scrollbar.configure sb ~command:(Listbox.yview lb)
let _ =
  scroll_link stack_sb stack_lb

(* Themes *)
let radio_frame = Frame.create right_frame
let themes_b1 = Radiobutton.create radio_frame
		~text:"Slection" ~value:""
and themes_b2 = Radiobutton.create radio_frame
		~text:"Tous" ~value:"1"


let themes_frame = Frame.create right_frame
		   (*~width:Tk_default.stack_width
		   ~height:Tk_default.stack_height*)

let themes_lb = Listbox.create themes_frame
let themes_sb = Scrollbar.create themes_frame
  

let _ = scroll_link themes_sb themes_lb

