(* $Id: user_info.ml,v 1.3 2001/06/16 17:05:03 mjambon Exp $ *)

open Printf
open Str

open Com
open Connect

(*
# qui Nosferatu
--- Rponse OK (1 ligne(s)) ---
Nosferatu : mjambon@ens-lyon.fr (Martin Jambon)
*)

type t = { ui_login : string;
	   ui_email : string;
	   ui_name : string }

let null = { ui_login = "";
	     ui_email = "";
	     ui_name = "" }

let create () = { ui_login = "";
		  ui_email = "";
		  ui_name = "" }

let make login email name = { ui_login = login;
			      ui_email = email;
			      ui_name = name }

let output_ui outchan ui =
  fprintf outchan "%s\n%s\n%s\n"
    ui.ui_login ui.ui_email ui.ui_name

let re_user = regexp "^\\(.*\\) : \\([^ ]*\\) (\\([^)]*\\))$"

let parse_info line =
  if string_match ~pat:re_user line ~pos:0 then
    Some { ui_login = matched_group 1 line;
	   ui_email = matched_group 2 line;
	   ui_name = matched_group 3 line }
  else None

let file = Default.user_infos

let table = Hashtbl.create 149
let _ = 
  if not (Hashtbl.mem table "")
  then Hashtbl.add table ~key:"" ~data:(make "" "" "")

let record_dodo_data login email name =
  let ui = { ui_login = login;
	     ui_email = email;
	     ui_name = name } in
  Hashtbl.add table ~key:login ~data:ui

let input () =
  try
    let inchan = open_in file in
    let rec iter () =
      try
	let line1 = input_line inchan in
	let line2 = input_line inchan in
	let line3 = input_line inchan in
	record_dodo_data line1 line2 line3;
	iter ()
      with End_of_file -> close_in inchan in
    iter ()
  with _ -> ()

let really_output () =
  let outchan = open_out file in
  Hashtbl.iter ~f:(fun ~key:un ~data:ui -> output_ui outchan ui)
    table;
  close_out outchan

let new_users = ref false
let output () =
  if !new_users then really_output ()


let really_get user_login =
  let ui = ref None in
  let self = Thread.self in
  let cond = Condition.create ()
  and mutex = Mutex.create () in

  let signal exn =  
    Mutex.lock mutex;
    Condition.signal cond;
    Mutex.unlock mutex in

  let action response = 
    (match response with
	 Finite_response (1,[s]) -> 
	   new_users := true;
	   ui := parse_info s
       | Error s -> ()
       | other -> ());
    Mutex.lock mutex;
    Condition.signal cond;
    Mutex.unlock mutex in
  
  Mutex.lock mutex;
  let command = ["qui ";user_login;"\n"] in
  dino_send_command command [action] ~error_handler:signal;
  Condition.wait cond ~locking:mutex;
  Mutex.unlock mutex;

  !ui


let get user_login =
  try Some (Hashtbl.find table user_login)
  with Not_found -> 
    let result = really_get user_login in
    (match result with
	 None -> ()
       | Some ui -> Hashtbl.add table ~key:user_login ~data:ui);
    result

let clean () = Unix.unlink file

