(* $Id: zap.ml,v 1.2 2001/06/15 19:24:18 mjambon Exp $ *)

open Printf

open Dino_message_type
open Header

let tbl = Hashtbl.create 293
let zap_num = ref 0
let some_are_zapped = ref false

let zapped num = Hashtbl.mem tbl num

let zap num = 
  if not (Hashtbl.mem tbl num) then 
    (Hashtbl.add tbl ~key:num ~data:();
     incr zap_num;
     some_are_zapped := true;
     true)
  else false

let unzap num = 
  if Hashtbl.mem tbl num then
    (Hashtbl.remove tbl num;
     decr zap_num;
     if !zap_num = 0 then some_are_zapped := false;
     true)
  else false

let should_zap msg =
  if !some_are_zapped then
    let hdr = msg.msg_header in
    let parents = hdr.hr_rep in
    if List.for_all ~f:zapped parents then
      (ignore (zap hdr.hr_num);
       true)
    else
      false
  else
    false

let unzap_all () = 
  Hashtbl.clear tbl;
  zap_num := 0;
  some_are_zapped := false
