

/************************************************************************/
/* commande 'sall', par Sbastien Lacour (DSM97), mai 2000              */
/* slacour@ens-lyon.fr                                                  */
/************************************************************************/

/* POSIX thread Safe */

#include "common.h"


/************************************************************************/
/* int communic (int port)                                              */
/* ouvre une socket TCP sur le port IP_PORT, retourne '-1' en cas       */
/* d'erreur                                                             */
/************************************************************************/

int communic (int port)
{
   int file_descr,result,val=1;
   struct sockaddr_in addr;
   int length = sizeof(struct sockaddr_in);

   file_descr = socket(AF_INET,SOCK_STREAM,0);
   if ( file_descr == -1 )
   {
      perror("\aSOCKET ");
      return(file_descr);
   }
   result = setsockopt(file_descr,SOL_SOCKET,SO_REUSEADDR,(void*)&val,
                                             sizeof(val));
   addr.sin_addr.s_addr = htonl(INADDR_ANY);
   addr.sin_family = AF_INET;
   addr.sin_port = htons(port);
   result = bind(file_descr,(struct sockaddr *)&addr,length);
   if (result)
   {
      perror("\aBIND ");
      shutdown(file_descr,2);
      close(file_descr);
      return(-1);
   }
   if ( getsockname(file_descr,(struct sockaddr *)&addr,&length) )
   {
      perror("\aGETSOCKNAME ");
      shutdown(file_descr,2);
      close(file_descr);
      return(-1);
   }
   if ( port && port != ntohs(addr.sin_port) ) return(-1);
   return(file_descr);
}


