
/************************************************************************/
/* commande 'sall', par Sbastien Lacour (DSM97), mai 2000              */
/************************************************************************/

#ifndef COMMON_H
#define COMMON_H

/* chaine de caracteres envoyee par le serveur en debut de connexion */
/* pour etre reconnu, et en fin de connexion pour signifier la-dite fin */
#define MAGIC_STRING "ababababababab4dsr87g6s5d4f65x4vc897grqzdv132ds"

/* chaine de caracteres emise par le daemon salld apres la premiere */
/* MAGIC_STRING pour donner sa version */
#define CURRENT_VERSION "salld_1.2"

/* Numro de version de sall/salld incrment  chaque mise  jour */
#define SALL_VERSION "1.2.1"

/* taille maxi des champs 'real_name' et 'nickname & group' en */
/* nbr de caracteres */
#define FIELD_SIZE 16

/* dure maxi d'attente de connexion des threads pour rcuprer */
/* les donnes (en secondes !) */
#define MAX_TIME 5

/* taille maxi des chaines de caracteres temporaires (noms de */
/* fichiers, group name, full name ...)                       */
/* doit etre suprieur  FIELD_SIZE  */
#define MAX_SIZE 2048
#define MAX_SIZE_STRING "2048"

/* quelques tailles de chaines de caracteres... ne pas toucher */
#define _UT_CONSOLE 32
#define _UT_HOSTNAME 257


/* port FIXE sur lequel fonctionne le systm client-server 'sall' */
#define IP_PORT (IPPORT_USERRESERVED+30)

#include <stdlib.h>
#include <netinet/in.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <string.h>
#include <stdio.h>


/************************************************************************/
/* prototypes                                                           */
/************************************************************************/

int communic (int);

/************************************************************************/
/* Debug                                                                */
/************************************************************************/

#ifdef DEBUG
#ifdef LINUX
#define LOG(str, args...)     fprintf(stderr, "%li " str "\n" , pthread_self(), ## args)
#define LOG_IN()              fprintf(stderr, "%li " __FUNCTION__": -->\n", pthread_self())
#define LOG_OUT()             fprintf(stderr, "%li " __FUNCTION__": <--\n", pthread_self())
#define LOG_VAL(str, val)     fprintf(stderr, "%li " str " = %d\n" , pthread_self(), (int)(val))
#define LOG_PTR(str, ptr)     fprintf(stderr, "%li " str " = %p\n" , pthread_self(), (void *)(ptr))
#define LOG_STR(str, str2)    fprintf(stderr, "%li " str " : %s\n" , pthread_self(), (char *)(str2))
#endif /* Linux */
#ifdef SOLARIS
#define LOG(str, args...)     fprintf(stderr, "%i " str "\n" , pthread_self(), ## args)
#define LOG_IN()              fprintf(stderr, "%i " __FUNCTION__": -->\n", pthread_self())
#define LOG_OUT()             fprintf(stderr, "%i " __FUNCTION__": <--\n", pthread_self())
#define LOG_VAL(str, val)     fprintf(stderr, "%i " str " = %d\n" , pthread_self(), (int)(val))
#define LOG_PTR(str, ptr)     fprintf(stderr, "%i " str " = %p\n" , pthread_self(), (void *)(ptr))
#define LOG_STR(str, str2)    fprintf(stderr, "%i " str " : %s\n" , pthread_self(), (char *)(str2))
#endif /* Solaris */
#else /* DEBUG */
#define LOG(str, args...) 
#define LOG_IN() 
#define LOG_OUT() 
#define LOG_VAL(str, val) 
#define LOG_PTR(str, ptr) 
#define LOG_STR(str, str2)
#endif /* DEBUG */

#endif

