
/************************************************************************/
/* commande 'sall', par Sbastien Lacour (DSM97), mai 2000              */
/************************************************************************/

#include "daemon.h"

#ifdef TRANSLATE_GROUP
#include <glib.h>
GHashTable *htable=NULL;
GStringChunk *chunk=NULL;

void read_hash_table(int sig)
{
  gchar *login;
  gchar *groupe;
  FILE *file;
  char *filename;
#define MAX_SIZE_LOGIN_GROUP 8
  char chaine[MAX_SIZE_LOGIN_GROUP+2];
  char *tampon;
  int nb=0;

  LOG_IN();

  if(htable)
    g_hash_table_destroy(htable);
  if(chunk)
    g_string_chunk_free(chunk);
  chunk=g_string_chunk_new(10000);
  htable=g_hash_table_new(g_str_hash, g_str_equal);

  filename=getenv("TRANSLATE_GROUP_FILE");
  if (!filename) {
    printf("Empty environment variable TRANSLATE_GROUP_FILE\n"
	   "Not inserting any translation\n");
    return;
  }
  file=fopen(filename, "r");
  if (!file) {
    printf("Unable to open %s\n"
	   "Not inserting any translation\n", filename);
    return;
  }

  for(;;) {
    tampon=fgets(chaine, MAX_SIZE_LOGIN_GROUP+2, file);
    if (!tampon)
      break;
    for(;*tampon; tampon++)
      if (*tampon == '\n')
	*tampon = 0;
    if (strlen(chaine) == MAX_SIZE_LOGIN_GROUP+1) {
      printf("login %s too long\nAborting\n", chaine);
      break;
    }
    login=g_string_chunk_insert_const(chunk, chaine);

    tampon=fgets(chaine, MAX_SIZE_LOGIN_GROUP+2, file);
    if (!tampon) {
      printf("Failed to read group for %s\n"
	     "Aborting\n", login);
      break;
    }
    for(;*tampon; tampon++)
      if (*tampon == '\n')
	*tampon = 0;
    if (strlen(chaine) == MAX_SIZE_LOGIN_GROUP+1) {
      printf("group %s too long for login %s\n"
	     "Aborting\n", chaine, login);
      break;
    }
    groupe=g_string_chunk_insert_const(chunk, chaine);

    nb++;
    LOG("Inserting (%s, %s)\n", login, groupe);
    g_hash_table_insert(htable, login, groupe);

  }
  LOG("%i tranlation read\n", nb);
  LOG_OUT();
}

char *translate_groupe(char* login)
{
  LOG_IN();
  LOG_OUT();
  return g_hash_table_lookup(htable, login);
}
#else
void read_hash_table(int sig)
{
}

char *translate_groupe(char* login)
{
  return NULL;
}
#endif /* TRANSLATE_GROUP */

#ifdef LINUX
/************************************************************************/
/* int is_locked_LINUX (uid_t user_id)                                  */
/* renvoie 1 si le user (user_id) fait tourner xlock ou dtscreen, 0     */
/* sinon                                                                */
/************************************************************************/

int is_locked_LINUX (uid_t user_id)
{
   DIR *directory;
   struct dirent *directory_entry;

   LOG_IN();
   directory=opendir("/proc/");
   if ( directory == NULL )
   {
      perror("\aOPENDIRECTORY ");
      return(0);
   }

   while ( (directory_entry=readdir(directory)) != NULL )
      if ( atoi(directory_entry->d_name) != 0 )
      { /* on a bien un numro de processus dans /proc/ */
         char file_name[MAX_SIZE+1];
         FILE *f;

         snprintf(file_name,MAX_SIZE,"/proc/%s/cmdline",
                            directory_entry->d_name);
         if ( NULL == (f = fopen(file_name,"r")) )
         {
            perror(file_name);
            if ( closedir(directory) != 0 ) perror("CLOSEDIRECTORY ");
         }
         else /* on a russi  ouvrir le fichier cmdline du processus courant */
         {
            char s[MAX_SIZE+1];

            strcpy(s,"");
            fscanf(f,"%"MAX_SIZE_STRING"s",s);

/*** ici, il faudrait parser plus serieusement la ligne de commande avec */
/*** regcomp sur (/usr/.../.../.../.../)xlock..., sinon "echo xlock" sera */
/*** aussi pris pour une session verouillee! */
            if ( NULL != strstr(s,"xlock") || NULL != strstr(s,"dtscreen") )
            {
               FILE *environ;

               snprintf(file_name,MAX_SIZE,"/proc/%s/environ",
                                  directory_entry->d_name);
               if ( NULL == (environ = fopen(file_name,"r")) )
               {
                  perror(file_name);
                  if ( closedir(directory) != 0 ) perror("CLOSEDIRECTORY ");
               }
               else
               {
/*** check here it's the right user: il doit y avoir dans ce fichier la chaine */
/*** de caracteres "LOGNAME=`~user_id~`... c'est trop chiant! */
                     fclose(f);
                     fclose(environ);
                     return(1);
               }
            }
            fclose(f);
         } /* fin d'ouverture du fichier */
      }
   if ( closedir(directory) != 0 ) perror("CLOSEDIRECTORY ");
   LOG_OUT();
   return(0);
}
#endif /* LINUX */



#ifdef SOLARIS
/************************************************************************/
/* int is_locked_SOLARIS (uid_t user_id)                                */
/* renvoie 1 si le user (user_id) fait tourner xlock ou dtscreen, 0     */
/* sinon                                                                */
/************************************************************************/

int is_locked_SOLARIS (uid_t user_id)
{
   DIR *directory;
   struct dirent *directory_entry;

   LOG_IN();
   directory=opendir("/proc/");
   if ( directory == NULL )
   {
      perror("\aOPENDIRECTORY ");
      return(0);
   }

   while ( (directory_entry=readdir(directory)) != NULL )
      if ( strcmp(".",directory_entry->d_name) &&
           strcmp("..",directory_entry->d_name) )
      { /* on a bien un numro de processus dans /proc/ */
         char file_name[MAX_SIZE+1];
         FILE *f;

         snprintf(file_name,MAX_SIZE,"/proc/%s/psinfo",
                                     directory_entry->d_name);
         if ( NULL == (f = fopen(file_name,"r")) )
         {
            perror(file_name);
            if ( closedir(directory) != 0 ) perror("CLOSEDIRECTORY ");
         }
         else /* on a russi  ouvrir le fichier psinfo du processus courant */
         {
            psinfo_t pi;

            if ( !fread(&pi,sizeof(psinfo_t),1,f) )
               perror("fread ");
            else /* on a russi  lire la structure dans le fichier */
            {
               if ( !strcmp(pi.pr_fname,"xlock") || 
                    !strcmp(pi.pr_fname,"dtscreen") )
                  if ( pi.pr_uid == user_id )
                  {
                     fclose(f);
                     return(1);
                  }
            } /* fin de lecture de la structure dans le fichier */
            fclose(f);
         } /* fin d'ouverture du fichier */
      } /* fin d'tude du processus courant */

   if ( closedir(directory) != 0 ) perror("CLOSEDIRECTORY ");
   LOG_OUT();
   return(0);
}
#endif /* SOLARIS */


/************************************************************************/
/* int is_locked         (uid_t user_id)                                */
/* renvoie 1 si le user (user_id) fait tourner xlock ou dtscreen, 0     */
/* sinon                                                                */
/************************************************************************/

int is_locked (uid_t user_id)
{
   LOG_IN();
#ifdef SOLARIS
   return(is_locked_SOLARIS(user_id));
#else
#ifdef LINUX
   return(is_locked_LINUX(user_id));
#else
   return(0);
#endif /* LINUX */
#endif /* SOLARIS */
   LOG_OUT();
}



/************************************************************************/
/* void snd_lgn (int fd,char *lgn)                                      */
/* envoie dans le file descriptor la ligne (NULL-terminated)            */
/************************************************************************/

void snd_lgn (int fd,char *lgn)
{
   int l,i;

   LOG_IN();
   if (lgn != NULL)
   {
      l = strlen(lgn);
      for (i=0 ; i<l ; i++)
         write(fd,&lgn[i],sizeof(char));
   }
   write(fd,"\n",sizeof(char));
   LOG_OUT();
   return;
}


/************************************************************************/
/* void stop_at_comma (char *full_name)                                 */
/* remplace la premire occurence de virgule ',' dans le full_name      */
/* par le character NULL '\0', car LINUX inclue tout un tas de          */
/* renseignements dans le full_name (gecos)                             */
/************************************************************************/

void stop_at_comma (char *full_name)
{
   int i=-1;
   LOG_IN();

   while ( full_name[++i] != '\0' )
      if ( full_name[i] == ',' ) full_name[i]='\0';

   LOG_OUT();
   return;
}



/************************************************************************/
/* void snd_nick_name (int fd,char *user)                               */
/* recherche en envoie le fsalname (a dfaut le user name)              */
/************************************************************************/

void snd_nick_name (int fd,char *user)
{
   char file[MAX_SIZE+1],nick[MAX_SIZE+9];
   FILE *f;

   LOG_IN();
   snprintf(file,MAX_SIZE,"/home/%s/.fsalname",user);
   f = fopen(file,"r");
   if ( f != NULL )
   {
      int i;
      char c;

      i=0;

      strcpy(nick,"");
      /* oter les caracteres non imprimables pour ne pas les */
      /* mettre dans nick */
      while ( i<FIELD_SIZE && fread(&c,sizeof(char),1,f) )
         if (isprint((int)c))
         {
            strncat(nick,&c,1);
            i++;
         }
      fclose(f);
   }
   else strcpy(nick,user);
   snd_lgn(fd,nick);

   LOG_OUT();
   return;
}



/************************************************************************/
/* void send_data (int file_descriptor)                                 */
/* envoie au client qui a donn le bon password les donnes :           */
/* array of users_login, console, log_time, host_name, full_users_name, */
/* group_name, nickname (fin : "MAGIC_STRING", pour terminer            */
/************************************************************************/

void send_data (int fd)
{
   struct utmpx *u;
   char *s;
   char *groupe;
   char console[_UT_CONSOLE] = "";

   LOG_IN();
   while ( (u=getutxent()) != NULL )
   {
      struct passwd *p;

      if (u->ut_type!=USER_PROCESS) continue;

      snd_lgn(fd,u->ut_user);
      s = ctime(&u->ut_tv.tv_sec);
      if ( s == NULL )
         snd_lgn(fd,"?");
      else
      {
         s[strlen(s)-1] = '\0';
         snd_lgn(fd,s);
      }
      p = getpwnam(u->ut_user);
      if ( p != NULL )
      {
         struct group *g;

#ifdef LINUX
         stop_at_comma(p->pw_gecos);
#endif
         snd_lgn(fd,p->pw_gecos);
#ifdef LINUX
         /* pour Linux, il faut tester si u->ut_host */
         /* contient ":" ou non.  Si le ut_host NE contient PAS ":", alors c'est */
         /* un login shell (console) et il faut tester is_locked */
         if ( NULL == strchr(u->ut_host, ':') )   /* c'est un login shell console */
         {
            if ( is_locked(p->pw_uid) ) strcpy(console,"locked");
            else strcpy(console,"console");
         }
         else strncpy(console, u->ut_line, _UT_CONSOLE*sizeof(char));
#endif
#ifdef SOLARIS
         if ( !strcmp(u->ut_line,"console") )   /* console de login physique */
         {
            if (is_locked(p->pw_uid)) strcpy(console,"locked");
            else strcpy(console,"console");
         }
         else if ( !strcmp(u->ut_line,"dtremote") )   /* console de remote login */
         {
            if (is_locked(p->pw_uid)) strcpy(console,"remote-locked");
            else strcpy(console,"remote");
         }
         else strncpy(console, u->ut_line, _UT_CONSOLE*sizeof(char));
#endif
         snd_lgn(fd,console);

	 groupe=translate_groupe(u->ut_user);
	 
	 if(groupe==NULL) {
	   g = getgrgid(p->pw_gid);
	   if ( g != NULL ) groupe=g->gr_name;
	 }

	 if ( groupe != NULL ) snd_lgn(fd,groupe);
	 else snd_lgn(fd,"?"); /* envoyer 1 lgn vide au client */
      }
      else /* envoyer 3 lignes vides au client si pas de champ ! */
      {
         snd_lgn(fd,"?");
         snd_lgn(fd,"?");
         snd_lgn(fd,"?");
      }
      snd_lgn(fd,u->ut_host);
      snd_nick_name(fd,u->ut_user);
   }
   LOG_OUT();
   return;
}


/************************************************************************/
/* void dead_child (int sig)                                            */
/* recupere la terminaison des fils-zombies                             */
/************************************************************************/

void dead_child (int sig)
{
   LOG_IN();
   while ( waitpid((pid_t)-1,NULL,WNOHANG) > 0 );
   LOG_OUT();
   return;
}


/************************************************************************/
/* void daemon_slaughter (int sig)                                      */
/* raise the -9 signal (to itself) in case a daemon would live too long */
/* for instance while trying to read a file too long ...                */
/************************************************************************/

void daemon_slaughter (int sig)
{
   LOG_IN();
   raise(SIGKILL);
   LOG_OUT();
   return;
}



/************************************************************************/
/* main prgrm                                                           */
/************************************************************************/


int main ()
{
   int file_descr;
   struct sockaddr_in addr_clnt;
   int length = sizeof(struct sockaddr_in);
   struct sigaction sa;

   LOG_IN();

   read_hash_table(0);

   /* rcuprer le signal de terminaison des fils morts-zombies */
   sa.sa_handler = dead_child;
   sigemptyset(&(sa.sa_mask));
   sa.sa_flags = 0;
//   sa.sa_flags = SA_NOCLDWAIT;
   if ( sigaction(SIGCHLD,&sa,NULL) )
   {
      perror("\aSIGACTION ");
      LOG_OUT();
      exit(7);
   }

   /* rcuprer SIGUSR1 pour relire les translations */
   sa.sa_handler = read_hash_table;
   sigemptyset(&(sa.sa_mask));
   sa.sa_flags = 0;
//   sa.sa_flags = SA_NOCLDWAIT;
   if ( sigaction(SIGUSR1,&sa,NULL) )
   {
      perror("\aSIGACTION ");
      LOG_OUT();
      exit(7);
   }

   file_descr = communic(IP_PORT);
   if (file_descr==-1)
   {
      fprintf(stderr,"Erreur lors de la cration de socket\a\n");
      LOG_OUT();
      exit(2);
   }
   if (listen(file_descr,1))
   {
      perror("\aLISTEN ");
      LOG_OUT();
      exit(3);
   }

   close(STDIN_FILENO); close(STDERR_FILENO);
   close(STDOUT_FILENO);

   while ( 1 )
   {
      int fd;
      pid_t pid;

      fd=accept(file_descr,(struct sockaddr *)&addr_clnt,&length);
      LOG("%s\n","Connection");
      if ( fd < 0 )
      {
//         perror("\aACCEPT ");
         continue;
      }
      if ( (pid=fork()) ) /* parent */
      {
         close(fd);
      }
      else /* son */
      {
         /* envoyer MAGIC_STRING pour dire "coucou, c'est moi le serveur" */
         /* et aussi pour dire "j'ai fini d'envoyer toutes les donnes" */
         /* envoyer aussi la version du demon apres MAGIC_STRING et avant */
         /* la premiere ligne de donnees (01112000) : CURRENT_VERSION */
         /* added on 09292000: time out to kill the son of a daemon */
         /* that would live too long, let's say MAX_TIME + 30 sec */
         /* with raising a '-9' signal ... just to be sure !  */
         struct sigaction kill_daemon;

	 LOG("%s\n","Begin answer");
         kill_daemon.sa_handler = daemon_slaughter;
         sigemptyset(&(kill_daemon.sa_mask));
         kill_daemon.sa_flags = 0;
         if ( sigaction(SIGALRM,&kill_daemon,NULL) )
         {
            perror("\aSIGACTION ");
            LOG_OUT();
            exit(19);
         }
         alarm(MAX_TIME + 30);

         close(file_descr);
         snd_lgn(fd,MAGIC_STRING);
         snd_lgn(fd, CURRENT_VERSION);
         send_data(fd);
         snd_lgn(fd,MAGIC_STRING);
         shutdown(fd,2);
         close(fd);
	 LOG("%s\n","End answer");
         LOG_OUT();
         exit(0);
      }
   }

   LOG_OUT();
   return(0);
}

