
/************************************************************************/
/* commande 'sall', par Sbastien Lacour (DSM97), mai 2000              */
/************************************************************************/

#ifndef SALL_H
#define SALL_H

#define _REENTRANT

#include "common.h"
#include <sys/resource.h>
#include <fcntl.h>
#include <arpa/inet.h>
//#include <semaphore.h>
#include <pthread.h>
#include <regex.h>


/* nom de domaine  ajouter  la fin des noms de machines */
#define DOMAIN_NAME ".ens-lyon.fr"
#define RESIDENCE_DOMAIN_NAME ".residence.ens-lyon.fr"



#define min(a,b) ( (a) < (b) ? (a) : (b) )
#define max(a,b) ( (a) > (b) ? (a) : (b) )



/************************************************************************/
/* type definitions                                                     */
/************************************************************************/


/* differentes versions du daemon salld */
/* CURRENT designe la derniere version du daemon */
/* NO_VERSION signifie que le daemon est une tres */
/* ancienne version qui ne donnait meme pas son */
/* numero de version ;  d'autres versions pourront */
/* etre ajoutees, telles que SALL_1_1, SALL_1_2 quand */
/* on aura CURRENT_VERSION == "salld_1.3" par exemple */
typedef enum { NO_VERSION = 0, VERSION_1_1, CURRENT } version_t;



typedef enum { EPICES=0 , ILES , VENTS ,
#ifdef lugdunum
               LUGDUNUM ,
#endif
               ANIMES , ALL , ALL_AND_ALL } rooms;
/* ALL = toutes les machines qui apparaissent sur les plans de salles */
/* ALL_AND_ALL = absolument toutes les machines, tant sur que hors des */
/* plans de salles */


/* GROUPS : crit le group des loggus (option '-g') */
/* NICKNAME : crit le fsalname des loggs (option '-f') */
/* DRAW_ROOM : pour dessiner le plan d'une salle passe en argument */
/* HOST : pour consulter les loggus sur une machine particulire (-h) */
/* LOGIN : pour grepper tous les logins qui match la RegExp (-n) */
/* LONG_FORMAT : pour afficher toutes les sessions (option '-l') */
/* ALL_MACHINES : pour afficher toutes les machines, meme celles */
/*                qui ne sont pas sur les plans des salles (-a) */

typedef enum { LIST=1 , LONG_FORMAT=2 , NICKNAME=4 , GROUPS=8 ,
               ALL_MACHINES=16 , HOST=32 , LOGIN=64 , DRAW_ROOM=128 ,
               SILENT=256 } request_type;


typedef struct
{
   request_type request;
   union
   {
      char host[64]; /* si request&HOST, option '-h' */
      char login[32]; /* si request&LOGIN, option '-n' */
      rooms rm; /* si request==DRAW_ROOM || LIST */
   } argmt;
} choice_type;


typedef enum { EXPECT_FLAG=1 , EXPECT_ROOM_NBR=2 , EXPECT_HOST_NAME=4 ,
               EXPECT_LOGIN=8 } expect_type;


/* les renseignements que fournit le daemon-sall sont */
/* dans un tableau (indice = numro de la machine) de */
/* listes chaines de tous ces renseignements (NULL = fin */
/* de la liste chainee, comme d'hab */

typedef struct info_host
{
   char user_logged[32];
   char console[32];
   char log_time[64];
   char host_name[257];
   char full_name[256];
   char group[64];
   char nickname[FIELD_SIZE+1];
   struct info_host *next;
} info_t;


/* liste chainee des machines (nom, numero de thread, info sur */
/* les loggues ...) qui vont etre interrogees */

typedef struct interest_struct
{
   char *name;
   info_t *info;
   pthread_t pthrid;
   pthread_t dsp_thrd;
   struct interest_struct *next;
} interest_t;



/* une petite structure pour ne pas rpter des affichages */
/* redondants (display_list, query_login, query_host) */
/* liste chaine des logins deja affichs */

typedef struct already_strct
{
   char login[32];
   struct already_strct *next;
} already_type;


#ifdef LINUX
typedef uint32_t in_addr_t;
#endif


/************************************************************************/
/* global variables                                                     */
/************************************************************************/


/* voila les noms des diffrentes machines rfrenables par */
/* la commande 'sall' : sparer les machines qui sont dans */
/* salles diffrentes par une chaine vide "" */
/* Mettre les machines qui n'apparaissent pas */
/* dans des plans de salle tout  la fin. */
/* La premiere chaine et la derniere chaine doivent rester des */
/* chaines vides.  L'avant derniere chaine vide indique la fin */
/* des machines qui apparaissent dans les plans de salles et le */
/* debut des autres machines */
/* si des nouvelles salles sont ajoutes, il faut les ajouter */
/* " la main" aussi dans 'typedef enum rooms' et dans la */
/* function 'analyze_arguments', 'get_argmt' */
/* les machines qui font partie de plans de salles doivent */
/* apparaitre ici dans LE MEME ORDRE que celui dans lequel */
/* elles sont invoques par les '#' des plans de salle */

char *machines[] = {
"",
/* LES EPICES : 7 machines */
"muscade","piment","curry","cannelle","safran","poivre","cumin","",
/* LES ILES : 9 machines */
"cuba","fidji","tonga","samoa","tahiti","vanuatu","martinique",
"jamaique","moorea","",
/* LES VENTS */
"simoun", "mistral", "foehn",
"blizzard", "alize", "tramontane", "ponant",
"brise", "hurricane", "sirocco", "",
#ifdef lugdunum
/* LUGDUNUM : 10 machines */
"bellecour","brotteaux","cordeliers","fourviere","gerland","montchat",
"monplaisir","perrache","terreaux","vaise","",
#endif
/* DESSINS ANIMS : 15 machines */
"musclor","pacman","babar","calimero","bibifoc","citesdor","candy",
"entrechats","ulysse31","bisounours","catseyes","albator","goldorak",
"cobra","clementine",
"",
/* machines qui n'apparaissent pas sur le plan des salles */
"dragon","telnet","gala","tennessee","pink-floyd", "info",
"pc-bde",
""
};



/* dans les plans des salles, les codes sont : */
/* '@' pour le nickname et le group sur FIELD_SIZE caracteres */
/* '^' pour le real_name sur FIELD_SIZE caracteres */
/* '#' pour les noms des machines, sur FIELD_SIZE caracteres */
/* les diffrentes salles, prsentes dans le meme ordre que */
/* 'typedef enum rooms', doivent tre spares par une chaine */
/* vide "". Laisser les deux chaines vides en debut et en fin */
/* de liste */

char *plan[] =
{
   "",
   "+--------------- Salle 112 (les Epices) --------------+",
   "|                                                     7",
   "|                  # #  0",
   "|                  @ @  .",
   "| # ^ ^  4",
   "| @                                    3",
   "| ^                                    +---------+",
   "|                                                               |",
   "| #                             # |",
   "| @                             @ |",
   "| ^                             ^ |",
   "|                                                               |",
   "| #           +----------------------------------+",
   "| @           |",
   "| ^           |",
   "|                            |",
   "| #           |",
   "| @           |",
   "| ^           |",
   "|                        \\   |",
   "|                         \\  |",
   "+---------------------o    o-+",
   "",
   "+-------------------- Salle 002 (les iles) --------------+",
   "|                                                        |",
   "|        #        #        |",
   "|        @        @        |",
   "|        ^        ^        |",
   "|                                                        |",
   "|                                                        |",
   "|        #        #        |",
   "|        @        @        |",
   "|        ^        ^        |",
   "|                                                        o",
   "7                                                          /",
   "0        #        #         /",
   ".        @        @        o",
   "8        ^        ^        |",
   "9                                                        |",
   "|                                                        |",
   "|  #  #  #  |",
   "|  @  @  @  |",
   "|  ^  ^  ^  |",
   "|                                                        |",
   "+--------------------------------------------------------+",
   "",
   "+----------------------- Salle 106 (les vents) --------------------o",
   "|                                                                   \\",
   "| # # #      lw106      \\",
   "| @ @ @      laser       o",
   "| ^ ^ ^      writer      |",
   "|                                                                     |",
   "| # # # # 7",
   "| @ @ @ @ 0",
   "| ^ ^ ^ ^ .",
   "|                                                                     4",
   "+----------------+ # # # 2",
   "                 | @ @ @ |",
   "                 | ^ ^ ^ |",
   "                 |                                                    |",
   "                 +----------------------------------------------------+",
   "",
   "+------------------- Salle 109 (les Dessins Anims) ------------------+",
   "|                                                                     |",
   "| # # # # |",
   "| @ @ @ @ |",
   "| ^ ^ ^ ^ o",
   "|                                                                        /",
   "|                                                                       /",
   "| # # # #  /",
   "| @ @ @ @ o",
   "| ^ ^ ^ ^ |",
   "|                                                                     |",
   "|                                                                     |",
   "|      lw109       # # # |",
   "|      laser       @ @ @ |",
   "|      writer      ^ ^ ^ |",
   "|                                                                     |",
   "|                                                                     |",
   "| # # # # |",
   "| @ @ @ @ |",
   "| ^ ^ ^ ^ |",
   "|                                                                     |",
   "+-------------------------------------71.83---------------------------+",
   ""
};


choice_type choice;


/* identifier du thread principal */
pthread_t main_pthread_id;


/* description des machines a interroger : ne peut pas etre defini autrement */
/* que globalement a cause de la fonction 'impatience' (signal handler) qui */
/* n'accepte qu'un seul parametre entier, a savoir le numero du signal recu */
interest_t *hosts;


#endif

