
if [ -n "$SCRATCH" -a -d "$SCRATCH" ]; then
	SCRATCH_HOME="$SCRATCH/${HOME#/home/}"
	export SCRATCH_HOME
	if [ ! -d "$(dirname "$SCRATCH_HOME")" ]; then
		echo 1>&2 "WARNING: missing directory $(dirname "$SCRATCH_HOME")"
		echo 1>&2 "WARNING: unsetting SCRATCH_HOME"
		unset SCRATCH_HOME
	else
		if [ ! -d "$SCRATCH_HOME" ]; then
			mkdir "$SCRATCH_HOME"
		fi
		if [ ! -d "$SCRATCH_HOME" ]; then
			echo 1>&2 "WARNING: cannot create $SCRATCH_HOME"
			echo 1>&2 "WARNING: unsetting SCRATCH_HOME"
			unset SCRATCH_HOME
		elif [ $(stat -c "%u" "$SCRATCH_HOME" ) != $(id -u) ]; then
			echo 1>&2 "WARNING: bad owner for $SCRATCH_HOME"
			echo 1>&2 "WARNING: unsetting SCRATCH_HOME"
			unset SCRATCH_HOME
		fi
	fi
else
	echo 1>&2 'WARNING: no SCRATCH set, not setting SCRATCH_HOME'
fi
