
add_info() {
	local SEP=""
	local AFTER=""
	case "$1" in
	--sep)  SEP="$(printf "%s\na" "$2" | sed -e 's,\\n,\n,g')"
		SEP="${SEP%%a}"
		shift ; shift ;;
	--after) AFTER="$2" ; shift ; shift ;;
	esac

	local FILE="$1"
	local REGEXP="$2"
	local VALUE="$3"
	local ENDPART="$4"

	if grep -sq "$REGEXP" "$FILE"; then
		if [ -z "$ENDPART" ]; then
			sed -e "/$(echo "$REGEXP" | sed -e 's,/,\\/,g')/s/^.*$/$(echo "$VALUE" | sed -e 's,/,\\/,g')/" -i "$FILE"
		else
			lead="$REGEXP"
			tail="$ENDPART"
			FVAL="$(mktemp)"
			printf "%s\n" "$VALUE" > "$FVAL"
			nl="$(printf "\n ")"
			nl="${nl/ /}"
			sed -e "/$lead/,/$tail/{ /$lead/{r $FVAL$nl}; d}" -i "$FILE"
		fi
	elif [ "$AFTER" = "" ]; then
		printf "%s" "$SEP" >> "$FILE"
		printf "%s\n" "$VALUE" >> "$FILE"
	elif ! grep -sq "$AFTER" "$FILE"; then
		echo 1>&2 "*************************"
		echo 1>&2 "$AFTER not found in $FILE"
		echo 1>&2 "Cannot insert $VALUE"
		echo 1>&2 "*************************"
	else
		VALUE="$(echo "$VALUE" | sed -e 's,\\,\\\\,g' -e 's,/,\\/,g')"
		AFTER="$(echo "$AFTER" | sed -e 's,/,\\/,g')"
		sed -e "/$AFTER/a $VALUE" -i "$FILE"
	fi
}

ucf_install() {
	local FILE2INSTALL="$1"
	local UCFR_OPTS="$2"
	local PACKAGE="$DPKG_MAINTSCRIPT_PACKAGE"
	local BDIR="/usr/share/$PACKAGE/ucf"
	local ifile
	local rmfile
	if [ -z "$FILE2INSTALL" ]; then
		FILE2INSTALL="#UCF_FILE_LIST#"
	fi
	for file in $FILE2INSTALL ; do
		ifile="$BDIR$file"
		rmfile=
		if [ -x "$ifile" ]; then
			ifile="$(mktemp -t "$(basename "$file").XXXXXXX")"
			cp -a "$BDIR$file" "$ifile"
			"$BDIR$file" "$PACKAGE" > "$ifile"
			if ! head -1 "$ifile" | grep -sq "^#!" ; then
				chmod -x "$ifile"
			fi
			rmfile="$ifile"
		fi
		destdir="$(dirname /"$file")"
		if test ! -d "$destdir"; then
			echo 1>&2 "WARNING: missing directory '$destdir', creating it"
			mkdir -p "$destdir"
		fi
		ucfr $UCFR_OPTS "$PACKAGE" "$file"
		ucf --three-way "$ifile" "$file"
		if [ -n "$rmfile" ]; then
			rm -f "$ifile"
		fi
	done
}

etckeeper_commit() {
	local MODIF="$(cd /etc && git status --porcelain)"
	if [ "$MODIF" != "" ]; then
		etckeeper commit -m "$DPKG_MAINTSCRIPT_PACKAGE: $1" || true
	fi
}
