del_info() {
	local FILE="$1"
	local REGEXP="$2"
	local ENDPART="$3"

	if grep -sq "$REGEXP" "$FILE"; then
		if [ -z "$ENDPART" ]; then
			sed -e "/$(echo "$REGEXP" | sed -e 's,/,\\/,g')/d" -i "$FILE"
		else
			lead="$REGEXP"
			tail="$ENDPART"
			sed -e "/$lead/,/$tail/d" -i "$FILE"
		fi
	fi
}


ucf_purge() {
	local FILE2PURGE="$1"
	local PACKAGE="$DPKG_MAINTSCRIPT_PACKAGE"
	local conffile ext
	if [ -z "$FILE2PURGE" ]; then
		FILE2PURGE="#UCF_FILE_LIST#"
	fi
	for conffile in $FILE2PURGE ; do
		ifile="$BDIR$file"
		# we mimic dpkg as closely as possible, so we remove configuration
		# files with dpkg backup extensions too:
		### Some of the following is from Tore Anderson:
		for ext in '~' '%' .bak .dpkg-tmp .dpkg-new .dpkg-old .dpkg-dist .ucf-old .ucf-new .ucf-dist;  do
		        rm -f $conffile$ext
		done
		# remove the configuration file itself
		rm -f $conffile
		# and finally clear it out from the ucf database
		if which ucf >/dev/null; then
		        ucf --purge $conffile
		fi
		if which ucfr >/dev/null; then
			if ! LC_ALL=C dpkg-divert --list "$conffile" | grep -sq " by $PACKAGE\$" ; then
				ucfr --purge $PACKAGE $conffile
			fi
		fi
	done
}

ucf_forget() {
	local FILE2PURGE="$1"
	local PACKAGE="$DPKG_MAINTSCRIPT_PACKAGE"
	local conffile ext
	if [ -z "$FILE2PURGE" ]; then
		FILE2PURGE="#UCF_FILE_LIST#"
	fi
	for conffile in $FILE2PURGE ; do
		ifile="$BDIR$file"
		# we mimic dpkg as closely as possible, so we remove configuration
		# files with dpkg backup extensions too:
		### Some of the following is from Tore Anderson:
		for ext in '~' '%' .bak .dpkg-tmp .dpkg-new .dpkg-old .dpkg-dist .ucf-old .ucf-new .ucf-dist;  do
		        rm -f $conffile$ext
		done
		# DO NOT remove the configuration file itself
		# rm -f $conffile
		# and finally clear it out from the ucf database
		if which ucf >/dev/null; then
		        ucf --purge $conffile
		fi
		if which ucfr >/dev/null; then
			if ! LC_ALL=C dpkg-divert --list "$conffile" | grep -sq " by $PACKAGE\$" ; then
				ucfr --purge $PACKAGE $conffile
			fi
		fi
	done
}
